package cn.ibizlab.util.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

@Data
@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@AllArgsConstructor
@ApiModel("文件")
public class FileDto
{
	@ApiModelProperty(value = "文件标识", position = 1)
	private String id;
	@ApiModelProperty(value = "文件名", position = 2)
	private String name;
	@ApiModelProperty(value = "文件流/base64", position = 3)
	private byte[] content;
}
